## -*-Tcl-*- 
 # ==========================================================================
 #  WWW Menu - an extension package for Alpha
 # 
 #  FILE: "wwwVersionHistory.tcl"
 #                                    created: 04/30/1997 {11:04:46 am} 
 #                                last update: 10/04/2001 {16:12:06 PM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #     
 #  Copyright (c) 1997-2001 Vince Darley, but freely distributable.
 #  Please send me bug fixes and improvements.
 # 
 # ==========================================================================
 ##

# This is a back compatibility proc, in case it is still used in other files.

proc wwwParseFile {{f ""} {title ""}} {WWW::renderFile $f $title} 

##
 # ==========================================================================
 # 
 #  ----  #
 # 
 #  Version History  #
 # 
 #  modified   by  rev reason
 #  ---------- --- --- -----------
 #  2000-12-07 DWH 1.2.2 updated help text
 #  2001-09-05 cbu 1.3   Put all procs in the WWW namespace.
 #                       Added WWW::renderUrl, available with Alphatk/8
 #  2001-09-09 VMD 1.4   Added mode declaration, rather than 'addMode'
 #  2001-09-13 cbu 1.5   Major restructuring of how links are handled, by
 #                         saving them as Tcl array vars rather than by
 #                         attempting to extract info via 'getColors'.
 #                       Added 'bookmarks' menu, history, search engines.
 #                       Incorporated Dominique's suggestions for improved
 #                         'WWW::parseHtml' and 'WWW::wrapInsertText'.
 #  2001-09-13 cbu 1.6   Lots of fixes.
 #  2001-09-13 cbu 1.6.1 Lots of fixes.
 #  2001-09-13 cbu 1.6.2 Lots of fixes.
 #                       History window now treated more like regular WWW.
 #                       <PRE> is now working again, better than before.
 #  2001-10-03 cbu 1.7   Options to ignore forms, images added.
 #                       New 'WWW::findClosingTag', used in creating links.
 #                       Many more links supported, esp those with 'extra'
 #                         arguments embedded in the tag.  Links that have
 #                         nested style tags will link but ignore style.
 #                       Many more web pages can be rendered.
 #                       Reloading a page after a cache flush now works, by
 #                         re-fetching the page (using WWW::UrlSource).
 #                       Non-html pages are simply inserted, not rendered.
 #                       The original wwwMenu.tcl file became much too large.
 #                       Broke it into four smaller ones, for mode, menu,
 #                        parsing, links.  Plus a fifth for history :)
 #                       
 # ==========================================================================
 ##

##
 # ==========================================================================
 # 
 #  WWW proc archives  #
 # 
 # Earlier version of the WWW menu used a different method for navigating
 # links within a document, by scanning the window for colors and then
 # performing a complicated series of regexps/subs to determine what
 # message should be displayed in the status bar window.  Alphatk tends to
 # complicate this method, and throws errors that I (cbu) can't trace.
 # 
 # The alternative method used above employs two principles:
 # 
 # -- all links are now made absolute before being embedded as hypertext
 # -- all link information is stored as a Tcl variable specific to the 
 #    window, and accessed as needed.
 # 
 # Hopefully, this exposes much of what is taking place and allows the
 # hypertexting/navigating/etc to be very OS independent.  One nice
 # by-product of this scheme is that it made the resolution of relative
 # urls a relative breeze.
 # 
 # One disadvantage that I've come across with the newer method is that if
 # a WWW window is saved and subsequently opened, it is not possible to
 # navigate the window using the arrow keys.  However, with the additional
 # 'bookmarks' and 'history' support, hopefully it won't be necessary to
 # actually save these WWW windows, since they can be easily rendered once
 # again using the WWW menu items.  Another disadvantage is that if there
 # are a large number of links in the window, navigating is a little slower
 # than one might expect due to the 'foreach' statement.
 # 
 # Anyway, since the earlier versions were pretty slick (at least for
 # Alpha7), I'm including them below.  To really see them in use, you'll
 # have to find an earlier version of this package, I'm afraid.
 # 
 # --------------------------------------------------------------------------
 # 
 # proc wwwUp {} {
 #     set link [wwwGetCurrentLink]
 #     _wwwHighlightLink [expr [lindex $link 1] -1]		
 # }
 # 
 # proc wwwDown {} {
 #     set link [wwwGetCurrentLink]
 #     _wwwHighlightLink [expr [lindex $link 0] +1]		
 # }
 # 
 # proc _wwwHighlightLink {l} {
 #     global _wwwLinks
 #     if {[set len [llength $_wwwLinks]] == 0} {return}
 #     if {$l < 0 || $l >= $len} {
 #         set l [expr ($l + $len) % $len]
 #         beep
 #     }
 #     set link [lindex $_wwwLinks $l]
 #     eval select $link
 #     set p [getPos]
 #     set q [selEnd]
 #     if {[info tclversion] >= 8.0} {
 #         regexp "\{ ?$p 15 \{wwwLink \"(\[^\"\]*)\"\} ?\}" [getColors] dmy link
 #     } else {
 #         regexp "\{ ?$p 15 \{wwwLink \"(\[^\"\]*)\"\} ?\} \{ ?$q 12 ?\}" [getColors] dmy link
 #     }
 #     message "Links to '$link'"
 #     return $link
 # }
 # 
 # proc wwwHighlightLink {l} {
 #     global _wwwLinks
 #     set _wwwLinks [_wwwGetLinks]
 #     _wwwHighlightLink $l
 # }
 # 
 # proc wwwGetCurrentLink {} {
 #     global _wwwLinks
 #     set _wwwLinks [_wwwGetLinks]
 #     set p [getPos]
 #     set i 0
 #     while 1 {
 #         if {[set j [lindex [lindex $_wwwLinks $i] 0]] == ""} {
 #             return [list [expr {$i-2}] [expr {$i-1}]]
 #         }
 #         if {[pos::compare $p <= $j]} {
 #             if {[pos::compare $p == $j]} {
 #                 return [list $i $i]
 #             } else {
 #                 return [list [expr {$i-1}] $i]
 #             }
 #         }
 #         incr i
 #     }
 #     incr i -1
 #     return [list $i $i]
 # }
 # 
 # proc wwwCopyLinkLocation {} {
 #     alertnote "Unimplemented."
 # }
 # 
 # proc _wwwGetLinks {} {
 #     regsub -all {\{wwwLink "[^"]*"\} ?} [getColors] "" g
 #     # remove all non 12,15 items
 #     regsub -all {\{ ?[.0-9]+ ([0-9]|1[0134]) ?\} ?} $g "" g
 #     # remove superimposed links (caused by editing)
 #     regsub -all {(\{ ?[.0-9]+ 15 ?\} )+(\{ ?[.0-9]+ 15 ?\} ?)} $g {\2} g
 #     # convert 15-12 list pairs into single items
 #     regsub -all { ?([.0-9]+) 15 ?\} \{ ?([.0-9]+) 12 ?} $g {\1 \2} g
 #     # remove random left-overs items
 #     regsub -all {\{ ?[.0-9]+ 12 ?\} ?} $g "" g
 #     return $g
 # }
 # 
 # ==========================================================================
 ##
